#include "memory_page.h"

#include <solomon/libs/cpp/selfmon/selfmon.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/malloc/api/malloc.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {
namespace {

class TDefaultMemoryPage: public NActors::TActor<TDefaultMemoryPage> {
public:
    TDefaultMemoryPage() noexcept
        : NActors::TActor<TDefaultMemoryPage>(&TThis::StateFunc) {
    }

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TEvPageDataReq, OnRequest)
            hFunc(NActors::TEvents::TEvPoison, OnPoison)
        }
    }

private:
    void OnRequest(const TEvPageDataReq::TPtr& ev) {
        Page page;
        page.set_title(TString{"Allocator: "} + NMalloc::MallocInfo().Name);

        auto* value = page.mutable_component()->mutable_value();
        value->set_string("Unable to get allocator stats");
        Send(ev->Sender, new TEvPageDataResp{std::move(page)});
    }

    void OnPoison(NActors::TEvents::TEvPoison::TPtr& ev) {
        Send(ev->Sender, new NActors::TEvents::TEvPoisonTaken);
        PassAway();
    }
};

} // namespace

std::unique_ptr<NActors::IActor> MemoryPage() {
    return std::make_unique<TDefaultMemoryPage>();
}

} // namespace NSolomon::NSelfMon
