#include "name.h"

#include <library/cpp/svnversion/svnversion.h>

#include <util/system/env.h>
#include <util/system/execpath.h>

TServiceInfo::TServiceInfo()
        : Name_{GetEnv("SERVICE_NAME", "")}
        , Version_{GetEnv("SERVICE_VERSION", "")}
{
    if (Name_.empty()) {
        Name_ = TStringBuf{GetExecPath()}.RAfter('/');
    }
    if (Version_.empty()) {
        Version_ = GetArcadiaLastChange();
        Version_ += '.';
        Version_ += GetBranch();
    }
}

TString& TServiceInfo::Name() {
    return Singleton<TServiceInfo>()->Name_;
}

TString& TServiceInfo::Version() {
    return Singleton<TServiceInfo>()->Version_;
}
