#include "proto_page.h"

#include <solomon/libs/cpp/selfmon/selfmon.h>

#include <library/cpp/actors/core/actor.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {
namespace {

class TProtoPage: public NActors::TActor<TProtoPage> {
public:
    explicit TProtoPage(std::shared_ptr<const ::google::protobuf::Message> msg) noexcept
        : NActors::TActor<TProtoPage>(&TThis::StateFunc)
        , Msg_{std::move(msg)}
    {
    }

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TEvPageDataReq, OnRequest)
            hFunc(NActors::TEvents::TEvPoison, OnPoison)
        }
    }

private:
    void OnRequest(const TEvPageDataReq::TPtr& ev) {
        Page page;
        if (Msg_) {
            page.set_title(Msg_->GetTypeName());
            auto* code = page.mutable_component()->mutable_code();
            code->set_content(Msg_->Utf8DebugString());
        }
        Send(ev->Sender, new TEvPageDataResp{std::move(page)});
    }

    void OnPoison(NActors::TEvents::TEvPoison::TPtr& ev) {
        Send(ev->Sender, new NActors::TEvents::TEvPoisonTaken);
        PassAway();
    }

private:
    std::shared_ptr<const ::google::protobuf::Message> Msg_;
};

} // namespace

std::unique_ptr<NActors::IActor> ProtoPage(std::shared_ptr<const ::google::protobuf::Message> msg) {
    return std::make_unique<TProtoPage>(std::move(msg));
}

} // namespace NSolomon::NSelfMon
