#include "threads_page.h"

#include <solomon/libs/cpp/selfmon/selfmon.h>

#include <library/cpp/actors/core/actor_bootstrapped.h>
#include <library/cpp/actors/core/hfunc.h>

using namespace yandex::monitoring::selfmon;
using namespace NActors;

namespace NSolomon::NSelfMon {
namespace {

class TThreadsPageNotSupported: public NActors::TActorBootstrapped<TThreadsPageNotSupported> {
public:
    TThreadsPageNotSupported() = default;

    void Bootstrap() {
        Become(&TThis::StateFunc);
    }

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(NSolomon::NSelfMon::TEvPageDataReq, OnRequest);
            hFunc(NActors::TEvents::TEvPoison, OnPoison);
        }
    }

private:
    void OnRequest(NSolomon::NSelfMon::TEvPageDataReq::TPtr ev) {
        Page page;
        page.set_title("Threads");

        page.mutable_component()->mutable_value()->set_string("procfs is not supported, cannot gather threads info");

        Send(ev->Sender, new TEvPageDataResp{std::move(page)});
    }

    void OnPoison(NActors::TEvents::TEvPoison::TPtr& ev) {
        Send(ev->Sender, new NActors::TEvents::TEvPoisonTaken);
        PassAway();
    }
};

} // namespace

std::unique_ptr<NActors::IActor> ThreadsPage() {
    return std::make_unique<TThreadsPageNotSupported>();
}

} // namespace NSolomon::NSelfMon
