#include "version_page.h"

#include <solomon/libs/cpp/selfmon/selfmon.h>

#include <library/cpp/actors/core/actor.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {
namespace {

class TVersionPage: public NActors::TActor<TVersionPage> {
public:
    TVersionPage()
        : NActors::TActor<TVersionPage>(&TThis::StateFunc)
    {
    }

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TEvPageDataReq, OnRequest)
            hFunc(NActors::TEvents::TEvPoison, OnPoison)
        }
    }

private:
    void OnRequest(const TEvPageDataReq::TPtr& ev) {
        Page page;
        auto* code = page.mutable_component()->mutable_code();
        code->set_content(GetProgramSvnVersion());

        Send(ev->Sender, new TEvPageDataResp{std::move(page)});
    }

    void OnPoison(NActors::TEvents::TEvPoison::TPtr& ev) {
        Send(ev->Sender, new NActors::TEvents::TEvPoisonTaken);
        PassAway();
    }
};

} // namespace

std::unique_ptr<NActors::IActor> VersionPage() {
    return std::make_unique<TVersionPage>();
}

} // namespace NSolomon::NSelfMon
