LIBRARY()

OWNER(g:solomon)

SRCS(
    logger_page.cpp
    proto_page.cpp
    service.cpp
    status_page.cpp
    version_page.cpp
    minidumps_page.cpp
    name.cpp
)

PEERDIR(
    solomon/libs/cpp/actors/runtime
    solomon/libs/cpp/backtrace
    solomon/libs/cpp/process_stats
    solomon/libs/cpp/selfmon/handler
    solomon/libs/cpp/minidump
    solomon/libs/cpp/minidump/metrics
    solomon/libs/cpp/trace

    library/cpp/html/escape
)

IF (OS_LINUX)
    SRCS(threads_page.cpp)
    PEERDIR(solomon/libs/cpp/process_stats)
ELSE()
    SRCS(threads_page_not_supported.cpp)
ENDIF()

IF(ALLOCATOR == "TCMALLOC_256K")
    SRCS(memory_page_tcmalloc.cpp)
    PEERDIR(
        contrib/libs/tcmalloc/malloc_extension
        solomon/libs/cpp/string_map
    )
ELSE()
    SRCS(memory_page_default.cpp)
ENDIF()

END()
