#include "layout.h"
#include "prefix.h"

#include "solomon/libs/cpp/selfmon/service/name.h"

namespace NSolomon::NSelfMon {

void TLayout::RenderHeader(IOutputStream* os) {
    os->Write("<head>"
                "<meta charset='utf-8'>"
                "<meta name='viewport' content='width=device-width, initial-scale=1'>"
                "<link rel='icon' href='/assets/favicon.96ce7d82d024fabd04542d8c096fec43.png' type='image/png'>"
                "<link href='/assets/bootstrap.abe91756d18b7cd60871a2f47c1e8192.min.css' rel='stylesheet'/>"
                "<link href='/assets/custom.63a6a240c4a10065f2963d93ccf176b4.css' rel='stylesheet'>"
                "<link href='/assets/bootstrap-icons.05090c6bd3c44f7e021d7059b56bd939.css' rel='stylesheet'>"
                "<link href='/assets/atom-one-light.ea2f9435dccf3393b02ca719c96c05e3.min.css' rel='stylesheet'>"
                "<link href='/assets/d3-flamegraph.css' rel='stylesheet'>"
                "<link href='/assets/d3-traceplot.css' rel='stylesheet'>"
    "<title>");

    os->Write(Title_);
    os->Write("</title></head>");
}

void TLayout::RenderSidebar(IOutputStream* os) {
    // TODO: output real process name, links and version
    *os << "<div class='d-flex flex-column flex-shrink-0 p-3 text-white bg-dark' style='width: 280px; height: 100vh;'>"
           "  <a href='" << BasePrefix << "' class='d-flex align-items-center mb-3 mb-md-0 me-md-auto text-white text-decoration-none'>"
           "    <span class='fs-4'>" << TServiceInfo::Name() << "</span>"
           "  </a>"
           "  <hr>"
           "  <ul class='nav nav-pills flex-column mb-auto'>";

    for (const auto& it: RootLinks_) {
        *os << "<li><a href='" << BasePrefix << it.first << "' class='nav-link";
        if (Path_ == it.first) {
            *os << " active";
        }
        *os << "'>" << it.second << "</a></li>";
    }

    const auto& version = TServiceInfo::Version();
    *os << "  </ul>"
           "  <hr>"
           "  <span class='badge bg-warning text-dark text-truncate' title='" << version << "'>" << version << "</span>"
           "</div>";
}

void TLayout::RenderFooter(IOutputStream* os) {
    *os << "<script src='/assets/bootstrap.0aa8d64e726c4a57adb5c88f9115996b.min.js'></script>"
           "<script src='/assets/highlight.0015a46c01fb1ffb19f1516faa71e797.min.js'></script>"
           "<script>hljs.highlightAll();</script>";
}

} // namespace NSolomon::NSelfMon
