#pragma once

#include <solomon/libs/cpp/selfmon/model/page.pb.h>
#include <solomon/libs/cpp/selfmon/view/render/render.h>

#include <util/stream/output.h>

#include <map>

namespace NSolomon::NSelfMon {

using TRootLinks = std::map<TString, TString>; // path -> title

class TLayout {
public:
    TLayout(TString path, TString title, TRootLinks rootLinks)
        : Path_{std::move(path)}
        , Title_{std::move(title)}
        , RootLinks_{std::move(rootLinks)}
    {
    }

    void Render(const TRenderContext& ctx, yandex::monitoring::selfmon::Page page, IOutputStream* os) {
        os->Write("<!doctype html><html lang='en'>");
        RenderHeader(os);
        RenderBody(ctx, std::move(page), os);
        RenderFooter(os);
        os->Write("</html>");
    }

private:
    void RenderHeader(IOutputStream* os);
    void RenderSidebar(IOutputStream* os);
    void RenderFooter(IOutputStream* os);

    void RenderBody(const TRenderContext& ctx, yandex::monitoring::selfmon::Page page, IOutputStream* os) {
        if (page.title().empty()) {
            page.set_title(Title_);
        }

        os->Write("<body><main>");
        RenderSidebar(os);
        ::NSolomon::NSelfMon::Render<decltype(page)>(ctx, page, os);
        os->Write("</main></body>");
    }

private:
    TString Path_;
    TString Title_;
    TRootLinks RootLinks_;
};

} // namespace NSolomon::NSelfMon
