#include "render.h"

#include <solomon/libs/cpp/selfmon/model/component.pb.h>

#include <library/cpp/html/escape/escape.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {
    template <>
    void Render<Component>(const TRenderContext& ctx, const Component& component, IOutputStream* os);

    template <>
    void Render<Collapsible>(const TRenderContext& ctx, const Collapsible& collapsible, IOutputStream* os) {
        *os << "<div><a href=\"#" << collapsible.id() << "\" data-bs-toggle=\"collapse\">" << collapsible.title() << "</a></div>"
               "<div class=\"collapse" << (collapsible.expanded() ? " show" : "") << "\" id=\"" << collapsible.id() << "\">";
        Render<Component>(ctx, collapsible.content(), os);
        *os << "</div>";
    }

    template <>
    void Render<CollapsibleList>(const TRenderContext& ctx, const CollapsibleList& collapsibleList, IOutputStream* os) {
        for (int index = 0; index < collapsibleList.collapsibles_size(); ++index) {
            Render<Collapsible>(ctx, collapsibleList.collapsibles(index), os);
        }
    }

} // namespace NSolomon::NSelfMon
