#include "render.h"

#include <solomon/libs/cpp/selfmon/model/component.pb.h>

#include <util/datetime/base.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {

template <typename TRepeatedField, typename TRenderer>
void RenderItems(const TRepeatedField& values, IOutputStream* os, TRenderer&& renderer) {
    for (const auto& value: values) {
        *os << "<li>";
        renderer(value);
        *os << "</li>";
    }
}

#define RENDER_FIELD(typeCase, field) \
    case List::typeCase: \
        RenderItems(list.field().values(), os, [&ctx, os](auto& value) { \
            Render<std::decay_t<decltype(value)>>(ctx, value, os); \
        }); \
        break

template <>
void Render<List>(const TRenderContext& ctx, const List& list, IOutputStream* os) {
    *os << (list.ordered() ? "<ol>" : "<ul>");

    switch (list.type_case()) {
        RENDER_FIELD(kBoolean, boolean);
        RENDER_FIELD(kInt32, int32);
        RENDER_FIELD(kUint32, uint32);
        RENDER_FIELD(kInt64, int64);
        RENDER_FIELD(kUint64, uint64);
        RENDER_FIELD(kFloat32, float32);
        RENDER_FIELD(kFloat64, float64);
        RENDER_FIELD(kString, string);
        RENDER_FIELD(kBytes, bytes);
        RENDER_FIELD(kReference, reference);
        RENDER_FIELD(kComponents, components);
        RENDER_FIELD(kFractions, fractions);

        case List::kTime: {
            RenderItems(list.time().values(), os, [&ctx, os](ui64 value) {
                Render<TInstant>(ctx, TInstant::FromValue(value), os);
            });
            break;
        }

        case List::kDuration: {
            RenderItems(list.duration().values(), os, [&ctx, os](ui64 value) {
                Render<TDuration>(ctx, TDuration::FromValue(value), os);
            });
            break;
        }

        case List::kDataSize: {
            RenderItems(list.data_size().values(), os, [&ctx, os](double value) {
                Render<TDataSize>(ctx, TDataSize{value}, os);
            });
            break;
        }

        case List::TYPE_NOT_SET:
            *os << "no items in list";
            break;
    }

    *os << (list.ordered() ? "</ol>" : "</ul>");
}

} // namespace NSolomon::NSelfMon
