#include "render.h"
#include "style.h"

#include <solomon/libs/cpp/selfmon/model/component.pb.h>
#include <solomon/libs/cpp/selfmon/view/prefix.h>

#include <util/datetime/base.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {

template <>
void Render<ListGroup>(const TRenderContext&, const ListGroup& listGroup, IOutputStream* os) {
    *os << "<div class='list-group'>";
    int active = listGroup.active();

    for (int i = 0, size = listGroup.items_size(); i < size; ++i) {
        const auto& item = listGroup.items(i);
        const auto& ref = item.reference();

        *os << "<a href='" << BasePrefix;
        if (!ref.page().StartsWith('/')) {
            *os << '/';
        }
        *os << ref.page();
        if (!ref.args().empty()) {
            *os << '?' << ref.args();
        }
        *os << "' class='list-group-item list-group-item-action";
        if (item.style() != Style::None) {
            *os << " list-group-item-" << StyleClass(item.style());
        }

        if (i == active) {
            *os << " active";
        }
        *os << "'>";

        if (!ref.title().empty()) {
            *os << ref.title();
        } else {
            *os << ref.page();
            if (!ref.args().empty()) {
                *os << '?' << ref.args();
            }
        }
        *os << "</a>";
    }

    *os << "</div>";
}

} // namespace NSolomon::NSelfMon
