#include "render.h"

#include <solomon/libs/cpp/selfmon/model/component.pb.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {

template <>
void Render<Object>(const TRenderContext& ctx, const Object& object, IOutputStream* os) {
    *os << "<div class='container-fluid mb-3'>";
    for (const auto& field: object.fields()) {
        *os << "<div class='row'><div class='col-md-3 field-name'>" << field.name()
            << "</div><div class='col-md-6 field-value'>";
        if (field.has_value()) {
            *os << "<small class='text-muted'>";
            Render<Value::TypeCase>(ctx, field.value().type_case(), os);
            *os << "</small> ";
            Render<Value>(ctx, field.value(), os);
        } else {
            *os << "field has no value";
        }
        *os << "</div></div>";
    }
    *os << "</div>";
}

} // namespace NSolomon::NSelfMon
