#include "render.h"

#include <solomon/libs/cpp/selfmon/model/page.pb.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {

template <>
void Render<Grid>(const TRenderContext& ctx, const Grid& grid, IOutputStream* os) {
    for (const auto& row: grid.rows()) {
        *os << "<div class='row'>";
        for (const auto& col: row.columns()) {
            if (auto w = col.width(); w > 0) {
                *os << "<div class='col-" << w << "'>";
            } else {
                *os << "<div class='col'>";
            }

            switch (col.type_case()) {
                case Grid_Column::kComponent:
                    Render<Component>(ctx, col.component(), os);
                    break;
                case Grid_Column::kGrid:
                    Render<Grid>(ctx, col.grid(), os);
                    break;
                case Grid_Column::TYPE_NOT_SET:
                    *os << "empty column";
                    break;
            }
            *os << "</div>";
        }
        *os << "</div>";
    }
}

template <>
void Render<Page>(const TRenderContext& ctx, const Page& page, IOutputStream* os) {
    *os << "<div class='container-fluid overflow-scroll'>";
    *os << "<h2 class='pt-3 pb-2 mb-3 border-bottom'>" << page.title() << "</h2>";

    if (page.has_component()) {
        Render<Component>(ctx, page.component(), os);
    } else if (page.has_grid()) {
        Render<Grid>(ctx, page.grid(), os);
    } else {
        *os << "Page is empty";
    }

    *os << "</div>";
}

} // namespace NSolomon::NSelfMon
