#include "render.h"

#include <solomon/libs/cpp/selfmon/model/value.pb.h>

#include <util/datetime/base.h>
#include <util/stream/format.h>
#include <util/string/hex.h>

using namespace yandex::monitoring::selfmon;

namespace NSolomon::NSelfMon {

#define RENDER_PRIMITIVE(type) \
    template <> \
    void Render<type>(const TRenderContext&, type value, IOutputStream* os) { \
        *os << value; \
    }

RENDER_PRIMITIVE(i32)
RENDER_PRIMITIVE(ui32)
RENDER_PRIMITIVE(i64)
RENDER_PRIMITIVE(ui64)
RENDER_PRIMITIVE(float)
RENDER_PRIMITIVE(double)

template <>
void Render<bool>(const TRenderContext&, bool value, IOutputStream* os) {
    *os << (value ? TStringBuf{"true"} : TStringBuf{"false"});
}

template <>
void Render<TInstant>(const TRenderContext&, TInstant value, IOutputStream* os) {
    if (value != TInstant::Max()) {
        *os << value.ToStringUpToSeconds();
    }
}

template <>
void Render<TDuration>(const TRenderContext&, TDuration value, IOutputStream* os) {
    if (value != TDuration::Max()) {
        *os << HumanReadable(value);
    }
}

template <>
void Render<TDataSize>(const TRenderContext&, const TDataSize& value, IOutputStream* os) {
    *os << HumanReadableSize(value.Vaue, SF_BYTES);
}

template <>
void Render<TString>(const TRenderContext&, const TString& str, IOutputStream* os) {
    *os << str;
}

template <>
void Render<TByteString>(const TRenderContext&, const TByteString& str, IOutputStream* os) {
    *os << HexEncode(str.Data, str.Size);
}

} // namespace NSolomon::NSelfMon
