#pragma once

#include <library/cpp/actors/http/http.h>
#include <library/cpp/string_utils/url/url.h>

#include <util/stream/output.h>

namespace NSolomon::NSelfMon {

struct TDataSize {
    double Vaue;
};

struct TByteString {
    const void* Data;
    const size_t Size;

    TByteString(const TString& str) noexcept
        : Data(str.data()), Size(str.size())
    {
    }
};

struct TRenderContext {
    ::NHttp::THttpIncomingRequest& Request;
    TStringBuf Url;
    TStringBuf Query;
    TStringBuf Fragment;

    explicit TRenderContext(::NHttp::THttpIncomingRequest& request)
        : Request{request}
    {
        SeparateUrlFromQueryAndFragment(Request.URL, Url, Query, Fragment);
    }

    TStringBuf Param(TStringBuf name) const {
        // linear search, because we will never have more than 10 params and it is
        // not needed to allocate memory to build hash map for find just one of them

        TStringBuf query = Query;
        while (!query.empty()) {
            auto val = query.NextTok('&');
            if (val.empty()) {
                continue; // && case
            }

            auto key = val.NextTok('=');
            if (key == name) {
                return val;
            }
        }
        return {};
    }
};

template <typename T>
void Render(const TRenderContext& ctx, typename TTypeTraits<T>::TFuncParam value, IOutputStream* os);

} // namespace NSolomon::NSelfMon

Y_DECLARE_PODTYPE(NSolomon::NSelfMon::TByteString);
