#include "shard_key.h"

#include <util/string/builder.h>

namespace NSolomon {
namespace {

template <typename TStream>
TStream& Write(TStream& s, const TShardKey& shardKey) {
    return s
        << TStringBuf("{ ProjectId: ") << shardKey.ProjectId
        << TStringBuf(", ClusterName: ") << shardKey.ClusterName
        << TStringBuf(", ServiceName: ") << shardKey.ServiceName
        << TStringBuf{"}"};
}

} // namespace

TString MakeShardId(const TShardKey& shardKey) {
    TStringBuf delim{"_"};
    return TString::Join(shardKey.ProjectId, delim, shardKey.ClusterName, delim, shardKey.ServiceName);
}

IOutputStream& operator<<(IOutputStream& os, const TShardKey& shardKey) {
    return Write(os, shardKey);
}

std::ostream& operator<<(std::ostream& os, const TShardKey& shardKey) {
    return Write(os, shardKey);
}

} // namespace NSolomon
