#pragma once

#include <util/generic/string.h>
#include <util/digest/multi.h>

namespace NSolomon {
    struct TShardKey {
        TShardKey() = default;
        TShardKey(TString projectId, TString clusterName, TString serviceName) noexcept
            : ProjectId(std::move(projectId))
            , ClusterName(std::move(clusterName))
            , ServiceName(std::move(serviceName))
        {
        }

        bool operator==(const TShardKey& other) const noexcept = default;

        bool Empty() const noexcept {
            return ProjectId.empty() && ClusterName.empty() && ServiceName.empty();
        }

        TString ProjectId;
        TString ClusterName;
        TString ServiceName;
    };

    TString MakeShardId(const TShardKey& key);

    IOutputStream& operator<<(IOutputStream& os, const TShardKey& shardKey);
    std::ostream& operator<<(std::ostream& os, const TShardKey& shardKey);

} // namespace NSolomon

template <>
struct THash<NSolomon::TShardKey> {
    size_t operator()(const NSolomon::TShardKey& shardKey) const noexcept {
        return MultiHash(shardKey.ProjectId, shardKey.ServiceName, shardKey.ClusterName);
    }
};
