#pragma once

#include <utility>

#include "resource_context.h"

namespace NSolomon {

class TResourceUsageContextProxy: public IResourceUsageContext {
public:
    explicit TResourceUsageContextProxy(IResourceUsageContextPtr impl)
        : Impl_{std::move(impl)}
    {
    }

    void SetMemoryBytes(ui64 val) override {
        Impl_->SetMemoryBytes(val);
    }

    void AddNetworkRxBytes(ui64 val) override {
        Impl_->AddNetworkRxBytes(val);
    }

    void AddNetworkTxBytes(ui64 val) override {
        Impl_->AddNetworkTxBytes(val);
    }

    void AddCpuTime(TDuration cpuTime) override {
        Impl_->AddCpuTime(cpuTime);
    }

    void Accept(TInstant time, NMonitoring::IMetricConsumer* consumer) const override {
        Impl_->Accept(time, consumer);
    }

    void Append(TInstant time, NMonitoring::IMetricConsumer* consumer) const override {
        Impl_->Append(time, consumer);
    }

    const TImmutableMetricRegistry& Registry() const override {
        return Impl_->Registry();
    }

protected:
    IResourceUsageContextPtr Impl_;

protected:
    void Init() override {
        Impl_->Init();
    }
};

} // namespace NSolomon
