#pragma once

#include <solomon/libs/cpp/testing/matchers.h>

#include <library/cpp/monlib/consumers/collecting_consumer.h>

template <typename T>
inline THolder<NMonitoring::TMetricTimeSeries> SinglePointSeries(T val, TInstant ts = TInstant::Zero()) {
    auto result = MakeHolder<NMonitoring::TMetricTimeSeries>();
    result->Add(ts, val);
    return result;
}

inline NMonitoring::ILabelsPtr Clone(NMonitoring::TLabels l) {
    return MakeIntrusive<NMonitoring::TLabels>(std::move(l));
};

inline NMonitoring::IHistogramSnapshotPtr MakeSnapshot(TVector<std::pair<NMonitoring::TBucketBound, NMonitoring::TBucketValue>> v) {
    struct TSnapshot: NMonitoring::IHistogramSnapshot {
        inline explicit TSnapshot(TVector<std::pair<NMonitoring::TBucketBound, NMonitoring::TBucketValue>>&& v)
            : Buckets{std::move(v)}
        {
        }

        TVector<std::pair<NMonitoring::TBucketBound, NMonitoring::TBucketValue>> Buckets;

        inline ui32 Count() const override {
            return Buckets.size();
        }

        inline NMonitoring::TBucketBound UpperBound(ui32 index) const override {
            return Buckets[index].first;
        }

        inline NMonitoring::TBucketValue Value(ui32 index) const override {
            return Buckets[index].second;
        }

        virtual ~TSnapshot() = default;
    };

    return new TSnapshot{std::move(v)};
}
