#pragma once

#include <solomon/libs/cpp/clients/slicer/api_types.h>

namespace NSolomon {

bool SlicesContain(const NSolomon::NSlicer::NApi::TSlices& slices, NSolomon::NSlicer::NApi::TNumId numId);

struct TMatchedNumIds {
    TVector<NSolomon::NSlicer::NApi::TNumId> Matched;
    TVector<NSolomon::NSlicer::NApi::TNumId> NotMatched;
};
/**
 * @param slices
 * @param numIds has to be sorted
 * @return
 */
TMatchedNumIds MatchSlicesWithNumIds(
        const NSolomon::NSlicer::NApi::TSlices& slices,
        const TVector<NSolomon::NSlicer::NApi::TNumId>& numIds);

/**
 * Returns a number of keys inside slices.
 *
 * Example:
 *    SlicesSize([ [1, 10], [11, 13] ]) -> 13
 */
ui32 SlicesSize(const NSolomon::NSlicer::NApi::TSlices& slices);

/**
 * Note: expects that `slices` has slices of total size >= numOfNumIdNeeded
 *
 * Example:
 *   ExtractSlicesOfTotalSize([ [1, 10], [11, 20], [21, 30] ], 15, extractTo)
 *   Then:
 *     - `extractTo` would be: [ [1, 10], [11, 15] ]
 *     - `slices` would be: [ [16, 20], [21, 30] ]
 */
NSolomon::NSlicer::NApi::TSlices::iterator ExtractSlicesOfTotalSize(
        NSolomon::NSlicer::NApi::TSlices& slices,
        NSolomon::NSlicer::NApi::TSlices::iterator it,
        ui32 numOfNumIdNeeded,
        NSolomon::NSlicer::NApi::TSlices& extractTo);

/**
 * Rearranges slices into parts as even as possible. If a number of keys inside all slices is not divisible by
 * numOfParts, the function will scatter remaining keys across as much parts as it can
 *
 * Examples:
 *   Rearrange([ [1, 7], [8, 10], [11, 15] ], 5) -> [ [[1, 3]], [[4, 6]], [[7, 9]], [[10, 12]], [[13, 15]] ]
 *   Rearrange([ [1, 7], [8, 10], [11, 13] ], 5) -> [ [[1, 3]], [[4, 6]], [[7, 9]], [[10, 11]], [[12, 13]] ]
 *   Rearrange([ [1, 1], [2, 4], [5, 6], [7, 8], [9, 12] ], 3) -> [ [[1, 1], [2, 4]], [[5, 6], [7, 8]], [[9, 12]] ]
 */
TVector<NSlicer::NApi::TSlices> RearrangeSlicesIntoEvenParts(
        NSlicer::NApi::TSlices& originalSlices,
        ui32 numOfParts);

} // namespace NSolomon
