
#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H

#include <library/cpp/testing/gtest/gtest.h>

#include <util/stream/buffer.h>
#include <util/generic/buffer.h>

using namespace NSolomon::NSlog;

TEST(TCodecTest, WriteReadFixed) {
    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        ASSERT_EQ(1u, WriteFixed<ui8>(&out, 1));
        ASSERT_EQ(1u, buffer.size());

        ASSERT_EQ(1u, WriteFixed<i8>(&out, 2));
        ASSERT_EQ(2u, buffer.size());

        ASSERT_EQ(2u, WriteFixed<ui16>(&out, 3));
        ASSERT_EQ(4u, buffer.size());

        ASSERT_EQ(2u, WriteFixed<i16>(&out, 4));
        ASSERT_EQ(6u, buffer.size());

        ASSERT_EQ(4u, WriteFixed<ui32>(&out, 5));
        ASSERT_EQ(10u, buffer.size());

        ASSERT_EQ(4u, WriteFixed<i32>(&out, 6));
        ASSERT_EQ(14u, buffer.size());

        ASSERT_EQ(8u, WriteFixed<ui64>(&out, 7));
        ASSERT_EQ(22u, buffer.size());

        ASSERT_EQ(8u, WriteFixed<i64>(&out, 8));
        ASSERT_EQ(30u, buffer.size());
    }

    {
        TBufferInput in(buffer);
        ASSERT_EQ(static_cast<ui8>(1), ReadFixed<ui8>(&in));
        ASSERT_EQ(static_cast<i8>(2), ReadFixed<i8>(&in));
        ASSERT_EQ(static_cast<ui16>(3), ReadFixed<ui16>(&in));
        ASSERT_EQ(static_cast<i16>(4), ReadFixed<i16>(&in));
        ASSERT_EQ(static_cast<ui32>(5), ReadFixed<ui32>(&in));
        ASSERT_EQ(static_cast<i32>(6), ReadFixed<i32>(&in));
        ASSERT_EQ(static_cast<ui64>(7), ReadFixed<ui64>(&in));
        ASSERT_EQ(static_cast<i64>(8), ReadFixed<i64>(&in));
    }
}

TEST(TCodecTest, SkipRead) {
    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        WriteFixed<ui16>(&out, 42);
        WriteFixed<ui8>(&out, 2);
        WriteFixed<ui16>(&out, 55);
    }

    {
        TBufferInput in(buffer);
        Skip(&in, 3);
        ASSERT_EQ(static_cast<ui16>(55), ReadFixed<ui16>(&in));
    }
}

TEST(TCodecTest, WriteZero) {
    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        ASSERT_EQ(5u, WriteZeros(&out, 5));
        ASSERT_EQ(5u, buffer.size());
    }

    {
        TBufferInput in(buffer);
        ASSERT_EQ(0u, ReadFixed<ui8>(&in));
        ASSERT_EQ(0u, ReadFixed<ui8>(&in));
        ASSERT_EQ(0u, ReadFixed<ui8>(&in));
        ASSERT_EQ(0u, ReadFixed<ui8>(&in));
        ASSERT_EQ(0u, ReadFixed<ui8>(&in));
    }
}

