#pragma once

#include <solomon/libs/cpp/log_writer/log_writer.h>
#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/ts_codec/bit_span.h>
#include <solomon/libs/cpp/ts_model/point_type.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/encode/spack/spack_v1.h>

#include <util/datetime/base.h>

namespace NSolomon::NSlog {
namespace NSlogData {

static constexpr ui16 HEADER_SIZE = 32;
static constexpr ui16 VERSION_1_0 = 0x0100;
static constexpr ui16 VERSION_2_0 = 0x0200;
static constexpr ui16 SKIP_BYTES = 1;

static constexpr ui16 VALID_MAGIC = 0x444C; // "LD" in LE-order
static constexpr ui16 CURRENT_VERSION = VERSION_2_0; // msb - major, lsb - minor

} // namespace NSlogData

enum class EDataCodingScheme: ui8 {
    Slog = 0x0,
    TsModel = 0x1,

    Last = TsModel,
};

class ILogDataBuilder {
public:
    virtual ~ILogDataBuilder() = default;

    virtual void Close() = 0;
    virtual void OnCommonTime(TInstant time) = 0;
    virtual void OnStep(TDuration step) = 0;
    virtual TBytes OnPoint(NTsModel::EPointType kind, ELogFlagsComb flags, TAggrPointWithType&& point) = 0;
    virtual TBytes OnTimeSeries(NTsModel::EPointType kind, ELogFlagsComb flags, const TAggrTimeSeries& timeseries) = 0;
    virtual TBytes OnTimeSeriesNativeEncoded(NTsModel::EPointType kind, ui16 columns, NTs::TBitSpan encoded, size_t numPoints) = 0;
};

using ILogDataBuilderPtr = THolder<ILogDataBuilder>;

ILogDataBuilderPtr CreateLogDataBuilder(
        ui32 numId,
        EDataCodingScheme codingScheme,
        NMonitoring::ETimePrecision timePrecision,
        NMonitoring::ECompression compressionAlg,
        IOutputStream* out);

} // namespace NSolomon::NSlog
