#include "log_index.h"

#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H

#include <util/stream/input.h>
#include <util/stream/output.h>
#include <util/system/types.h>

namespace NSolomon::NSlog {

void EncodeIndex(IOutputStream* out, const TSlogIndex& index) {
    WriteFixed(out, NSlogIndex::VALID_MAGIC);
    WriteFixed(out, NSlogIndex::CURRENT_VERSION);
    WriteFixed(out, index.Size());

    for (size_t i = 0; i != index.Size(); ++i) {
        WriteFixed(out, index.GetNumId(i));
        WriteFixed(out, index.GetMetaSizeBytes(i));
        WriteFixed(out, index.GetDataSizeBytes(i));
    }
}

TSlogIndex DecodeIndex(IInputStream* in) {
    ui16 magic = ReadFixed<ui16>(in);

    if (magic != NSlogIndex::VALID_MAGIC) {
        ythrow TDecodeError()
            << "invalid index magic: expected " << NSlogIndex::VALID_MAGIC << ", "
            << "got " << magic;
    }

    auto version = ReadFixed<ui16>(in);
    if (version > NSlogIndex::CURRENT_VERSION) {
        ythrow TDecodeError()
            << "unsupported version of index: " << version;
    }

    auto size = ReadFixed<ui32>(in);
    auto index = TSlogIndex(size);

    for (size_t i = 0; i != size; ++i) {
        auto numId = ReadFixed<ui32>(in);
        auto metaSizeBytes = ReadFixed<ui32>(in);
        auto dataSizeBytes = ReadFixed<ui32>(in);
        index.Add(numId, metaSizeBytes, dataSizeBytes);
    }

    return index;
}

} // namespace NSolomon::NSlog
