#include "builder.h"
#include "header.h"

#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H

#include <library/cpp/monlib/encode/spack/compression.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NMonitoring;
using namespace yandex::solomon::stockpile;

namespace NSolomon::NSlog::NResolvedMeta {

class TResolvedMetaBuilder: public IResolvedMetaBuilder {
public:
    TResolvedMetaBuilder(ui32 numId, EDecimPolicy decimPolicy, ui32 producerId, ui64 producerSeqNo, ECompression compressionAlg, IOutputStream* out)
        : Out_{out}
    {
        Header_.NumId = numId;
        Header_.DecimPolicy = decimPolicy;
        Header_.ProducerId = producerId;
        Header_.ProducerSeqNo = producerSeqNo;
        Header_.CompressionAlg = compressionAlg;
        CompressedOut_ = CompressedOutput(TempOut_, Header_.CompressionAlg);
        if (CompressedOut_) {
            TempOut_ = CompressedOut_.Get();
        }
    }

    void Close() override {
        if (IsClosed_) {
            return;
        }

        IsClosed_ = true;

        NResolvedMeta::WriteHeader(Out_, Header_);
        TempOut_->Finish();

        // TODO: a place for an optimization. Pass an arg stream that supports position changing
        const auto& tempBuffer = TempData_.Buffer();
        Out_->Write(tempBuffer.Data(), tempBuffer.Size());
    }

    void OnMetric(NTsModel::EPointType kind, ui64 localId, size_t pointsCnt, TBytes bytes) override {
        Header_.MetricsCount++;
        Header_.PointsCount += pointsCnt;

        WriteFixed(TempOut_, PackTypes(kind, NMonitoring::EValueType::NONE));
        WriteFixed<ui64>(TempOut_, localId);
        NMonitoring::WriteVarUInt32(TempOut_, pointsCnt);
        NMonitoring::WriteVarUInt32(TempOut_, bytes);
    }

private:
    THeader Header_;
    TBufferStream TempData_;
    IOutputStream* TempOut_{&TempData_};
    THolder<IOutputStream> CompressedOut_;
    IOutputStream* Out_;
    bool IsClosed_{false};
};

IResolvedMetaBuilderPtr CreateResolvedMetaBuilder(
    ui32 numId,
    EDecimPolicy decimPolicy,
    ui32 producerId,
    ui64 producerSeqNo,
    ECompression compression,
    IOutputStream* out)
{
    return MakeHolder<TResolvedMetaBuilder>(numId, decimPolicy, producerId, producerSeqNo, compression, out);
}

} // namespace NSolomon::NSlog::NResolvedMeta
