#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/ts_model/point_type.h>
#include <solomon/protos/stockpile/decim_policy.pb.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/metric_type.h>
#include <library/cpp/monlib/metrics/labels.h>

namespace NSolomon::NSlog::NResolvedMeta {

class IResolvedMetaBuilder {
public:
    virtual ~IResolvedMetaBuilder() = default;

    virtual void Close() = 0;
    virtual void OnMetric(NTsModel::EPointType type, ui64 localId, size_t pointsCnt, TBytes bytes) = 0;
};

using IResolvedMetaBuilderPtr = THolder<IResolvedMetaBuilder>;

IResolvedMetaBuilderPtr CreateResolvedMetaBuilder(
    ui32 numId,
    yandex::solomon::stockpile::EDecimPolicy decimPolicy,
    ui32 producerId,
    ui64 producerSeqNo,
    NMonitoring::ECompression compressionAlg,
    IOutputStream* out);

} // namespace NSolomon::NSlog::NResolvedMeta
