#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/protos/stockpile/decim_policy.pb.h>

#include <library/cpp/monlib/encode/format.h>

#include <util/stream/input.h>
#include <util/stream/output.h>

namespace NSolomon::NSlog::NResolvedMeta {

enum EVersion : ui8 {
    INIT = 1
};

static constexpr EVersion CURRENT_VERSION = EVersion::INIT;
static constexpr EVersion MIN_VERSION = EVersion::INIT;
static constexpr EVersion MAX_VERSION = EVersion::INIT;
static constexpr ui16 VALID_MAGIC = 0x4D52; // "RM" in LE-order

struct THeader {
    EVersion Version = CURRENT_VERSION;
    NMonitoring::ECompression CompressionAlg = NMonitoring::ECompression::IDENTITY;
    ui32 NumId = 0;
    yandex::solomon::stockpile::EDecimPolicy DecimPolicy = yandex::solomon::stockpile::EDecimPolicy::POLICY_5_MIN_AFTER_7_DAYS;
    ui32 ProducerId = 0;
    ui64 ProducerSeqNo = 0;
    ui32 MetricsCount = 0;
    ui32 PointsCount = 0;
};

THeader ReadHeader(IInputStream* in);

TBytes WriteHeader(IOutputStream* out, THeader header);

} // namespace NSolomon::NSlog::NResolvedMeta
