#include "iterator.h"
#include "header.h"

#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H

#include <library/cpp/monlib/encode/spack/compression.h>
#include <util/stream/mem.h>

#include <memory>

using namespace NMonitoring;

namespace NSolomon::NSlog::NResolvedMeta {

class TResolvedMetaIterator: public IResolvedMetaIterator {
public:
    explicit TResolvedMetaIterator(IInputStream* in)
        : Header_{NResolvedMeta::ReadHeader(in)}
    {
        // TODO: not working with compression from java, when hex represent data the same
        auto compressedIn = NMonitoring::CompressedInput(in, Header_.CompressionAlg);
        if (compressedIn) {
            Meta_ = compressedIn->ReadAll();
        } else {
            Meta_ = in->ReadAll();
        }
        Memory_ = TMemoryInput{Meta_};
    }

    explicit TResolvedMetaIterator(TString meta) {
        Memory_ = TMemoryInput(meta);
        Header_ = NResolvedMeta::ReadHeader(&Memory_);
        auto compressedIn = NMonitoring::CompressedInput(&Memory_, Header_.CompressionAlg);
        if (compressedIn) {
            Meta_ = compressedIn->ReadAll();
            Memory_ = TMemoryInput{Meta_};
        } else {
            Meta_ = std::move(meta);
        }
    }

    ui32 NumId() override {
        return Header_.NumId;
    }

    yandex::solomon::stockpile::EDecimPolicy DecimPolicy() override {
        return Header_.DecimPolicy;
    }

    ui32 ProducerId() override {
        return Header_.ProducerId;
    }

    ui64 ProducerSeqNo() override {
        return Header_.ProducerSeqNo;
    }

    ui32 TotalMetricCount() override {
        return Header_.MetricsCount;
    }

    ui32 TotalPointCount() override {
        return Header_.PointsCount;
    }

    bool HasNext() override {
        return MetricIdx_ < Header_.MetricsCount;
    }

    TResolvedMetaRecord Next() override {
        Y_VERIFY(HasNext());

        auto type = ReadPointType(ReadFixed<ui8>(&Memory_));
        ui64 localId = ReadFixed<ui64>(&Memory_);
        ui32 pointsCount = ReadVariadic(&Memory_);
        ui32 dataSize = ReadVariadic(&Memory_);
        ++MetricIdx_;
        return {type, localId, pointsCount, dataSize};
    }

private:
    THeader Header_;
    TString Meta_;
    TMemoryInput Memory_;

    size_t MetricIdx_{0};
};

IResolvedMetaIteratorPtr CreateResolvedMetaIterator(IInputStream* in) {
    return std::make_unique<TResolvedMetaIterator>(in);
}

IResolvedMetaIteratorPtr CreateResolvedMetaIterator(TString meta) {
    return std::make_unique<TResolvedMetaIterator>(std::move(meta));
}

} // namespace NSolomon::NSlog::NResolvedMeta
