#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/labels/labels.h>
#include <solomon/libs/cpp/ts_model/point_type.h>
#include <solomon/protos/stockpile/decim_policy.pb.h>

#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/generic/buffer.h>
#include <util/stream/input.h>
#include <util/generic/vector.h>

#include <vector>

namespace NSolomon::NSlog::NResolvedMeta {

struct TResolvedMetaRecord {
    NTsModel::EPointType Type;
    ui64 LocalId;
    ui32 PointCounts;
    TBytes DataSize;
};

class IResolvedMetaIterator {
public:
    virtual ~IResolvedMetaIterator() = default;
    virtual ui32 NumId() = 0;
    virtual yandex::solomon::stockpile::EDecimPolicy DecimPolicy() = 0;
    virtual ui32 ProducerId() = 0;
    virtual ui64 ProducerSeqNo() = 0;
    virtual ui32 TotalMetricCount() = 0;
    virtual ui32 TotalPointCount() = 0;

    virtual bool HasNext() = 0;
    virtual TResolvedMetaRecord Next() = 0;
};

using IResolvedMetaIteratorPtr = std::unique_ptr<IResolvedMetaIterator>;

IResolvedMetaIteratorPtr CreateResolvedMetaIterator(IInputStream* in);

IResolvedMetaIteratorPtr CreateResolvedMetaIterator(TString meta);

} // namespace NSolomon::NSlog::NResolvedMeta
