#include <solomon/libs/cpp/slog/resolved_meta/header.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/size_literals.h>
#include <util/stream/buffer.h>
#include <util/generic/buffer.h>

using namespace NSolomon::NSlog::NResolvedMeta;
using namespace yandex::solomon::stockpile;

TEST(TSlogResolvedMetaHeaderTest, EncodeDecode) {
    THeader header;
    header.NumId = 3078450851;
    header.PointsCount = 214;
    header.MetricsCount = 20;
    header.ProducerId = 42;
    header.ProducerSeqNo = 55;
    header.DecimPolicy = EDecimPolicy_MAX;
    header.CompressionAlg = NMonitoring::ECompression::ZLIB;

    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto bytes = WriteHeader(&out, header);
        ASSERT_EQ(bytes, buffer.size());
    }
    {
        TBufferInput in(buffer);
        THeader actual = ReadHeader(&in);
        ASSERT_EQ(header.NumId, actual.NumId);
        ASSERT_EQ(header.PointsCount, actual.PointsCount);
        ASSERT_EQ(header.MetricsCount, actual.MetricsCount);
        ASSERT_EQ(header.ProducerId, actual.ProducerId);
        ASSERT_EQ(header.ProducerSeqNo, actual.ProducerSeqNo);
        ASSERT_EQ(header.Version, actual.Version);
        ASSERT_EQ(header.CompressionAlg, actual.CompressionAlg);
    }
    EXPECT_THROW(ythrow yexception() << "msg", yexception);
}

TEST(TSlogResolvedMetaHeaderTest, InvalidHeader) {
    TString buffer = "RMInvalidHeaderThatShouldFail1111";
    TStringInput in(buffer);
    EXPECT_THROW(ReadHeader(&in), NSolomon::NSlog::TDecodeError);
}

TEST(TSlogResolvedMetaHeaderTest, CorruptedHeader) {
    THeader header;
    header.NumId = 1684122135;
    header.PointsCount = 15;
    header.MetricsCount = 255;
    header.DecimPolicy = POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_3_MONTHS;
    header.CompressionAlg = NMonitoring::ECompression::IDENTITY;

    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto bytes = WriteHeader(&out, header);
        ASSERT_EQ(bytes, buffer.size());
    }

    {
        buffer.Resize(buffer.size() / 2);
        TBufferInput in(buffer);
        EXPECT_THROW(ReadHeader(&in), NSolomon::NSlog::TDecodeError);
    }
}
