#include <solomon/libs/cpp/slog/resolved_meta/builder.h>
#include <solomon/libs/cpp/slog/resolved_meta/iterator.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/stream/buffer.h>

using namespace NMonitoring;
using namespace NSolomon::NSlog::NResolvedMeta;
using namespace yandex::solomon::stockpile;

inline void PrintTo(EMetricType type, std::ostream* stream) {
    *stream << MetricTypeToStr(type);
}

TEST(TSlogResolvedMetaTest, OneMetric) {
    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto builder = CreateResolvedMetaBuilder(1, EDecimPolicy::POLICY_KEEP_FOREVER, 2, 5, ECompression::IDENTITY, &out);
        builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 12345, 42, 128);
        builder->Close();
    }

    {
        TBufferInput in(buffer);
        auto it = CreateResolvedMetaIterator(&in);
        EXPECT_EQ(1u, it->NumId());
        EXPECT_EQ(2u, it->ProducerId());
        EXPECT_EQ(5u, it->ProducerSeqNo());
        EXPECT_EQ(EDecimPolicy::POLICY_KEEP_FOREVER, it->DecimPolicy());
        EXPECT_EQ(1u, it->TotalMetricCount());
        EXPECT_EQ(42u, it->TotalPointCount());
        ASSERT_TRUE(it->HasNext());

        auto record = it->Next();
        EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
        ASSERT_EQ(12345u, record.LocalId);
        EXPECT_EQ(42u, record.PointCounts);
        EXPECT_EQ(128u, record.DataSize);
        ASSERT_FALSE(it->HasNext());
    }
}

TEST(TSlogResolvedMetaTest, ManyMetrics) {
    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto builder = CreateResolvedMetaBuilder(55, EDecimPolicy::POLICY_5_MIN_AFTER_7_DAYS, 2, 333333, ECompression::IDENTITY, &out);
        {
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 1, 1, 8);
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 2, 1, 7);
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 3, 1, 6);
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 4, 1, 5);
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 123, 1, 4);
        }
        builder->Close();
    }

    {
        TBufferInput in(buffer);
        auto it = CreateResolvedMetaIterator(&in);
        EXPECT_EQ(55u, it->NumId());
        EXPECT_EQ(EDecimPolicy::POLICY_5_MIN_AFTER_7_DAYS, it->DecimPolicy());
        EXPECT_EQ(2u, it->ProducerId());
        EXPECT_EQ(333333u, it->ProducerSeqNo());
        EXPECT_EQ(5u, it->TotalMetricCount());
        EXPECT_EQ(5u, it->TotalPointCount());
        {
            ASSERT_TRUE(it->HasNext());
            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(1u, record.LocalId);
            EXPECT_EQ(1u, record.PointCounts);
            EXPECT_EQ(8u, record.DataSize);
        }
        {
            ASSERT_TRUE(it->HasNext());
            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(2u, record.LocalId);
            EXPECT_EQ(1u, record.PointCounts);
            EXPECT_EQ(7u, record.DataSize);
        }
        {
            ASSERT_TRUE(it->HasNext());
            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(3u, record.LocalId);
            EXPECT_EQ(1u, record.PointCounts);
            EXPECT_EQ(6u, record.DataSize);
        }
        {
            ASSERT_TRUE(it->HasNext());
            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(1u, record.PointCounts);
            EXPECT_EQ(4u, record.LocalId);
            EXPECT_EQ(5u, record.DataSize);
        }
        {
            ASSERT_TRUE(it->HasNext());
            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(123u, record.LocalId);
            EXPECT_EQ(1u, record.PointCounts);
            EXPECT_EQ(4u, record.DataSize);
        }
        ASSERT_FALSE(it->HasNext());
    }
}

TEST(TSlogResolvedMetaTest, Compression) {
    for (ECompression compression: {ECompression::IDENTITY, ECompression::ZLIB, ECompression::ZSTD, ECompression::LZ4}) {
        TString buffer;
        {
            TStringOutput out(buffer);
            auto builder = CreateResolvedMetaBuilder(1, EDecimPolicy::POLICY_5_MIN_AFTER_7_DAYS, 1, 5, compression, &out);
            builder->OnMetric(NSolomon::NTsModel::EPointType::DGauge, 43, 42, 128);
            builder->Close();
        }
        {
            auto it = CreateResolvedMetaIterator(std::move(buffer));
            EXPECT_EQ(1u, it->NumId());
            EXPECT_EQ(EDecimPolicy::POLICY_5_MIN_AFTER_7_DAYS, it->DecimPolicy());
            EXPECT_EQ(1u, it->ProducerId());
            EXPECT_EQ(5u, it->ProducerSeqNo());
            EXPECT_EQ(1u, it->TotalMetricCount());
            EXPECT_EQ(42u, it->TotalPointCount());
            ASSERT_TRUE(it->HasNext());

            auto record = it->Next();
            EXPECT_EQ(NSolomon::NTsModel::EPointType::DGauge, record.Type);
            EXPECT_EQ(43u, record.LocalId);
            EXPECT_EQ(42u, record.PointCounts);
            EXPECT_EQ(128u, record.DataSize);
            ASSERT_FALSE(it->HasNext());
        }
    }
}
