#pragma once

#include "solomon/libs/cpp/slog/codec/fwd.h"
#include <solomon/libs/cpp/log_writer/log_writer.h>
#include <solomon/libs/cpp/slog/unresolved_meta/builder.h>

#include <library/cpp/monlib/encode/encoder.h>
#include <library/cpp/monlib/encode/spack/spack_v1.h>
#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric_consumer.h>

namespace NSolomon::NSlog {

ILogWriterPtr CreateSlogEncoder(
        ui32 numId,
        NMonitoring::ETimePrecision timePrecision,
        NMonitoring::ECompression compressionAlg,
        IOutputStream* dataOut,
        IOutputStream* metaOut);

class TSlogIndex {
public:
    TSlogIndex(size_t elementsCnt)
        : Elements_{::Reserve(elementsCnt)}
    {}

    void Add(ui32 numId, ui32 metaSizeBytes, ui32 dataSizeBytes) {
        Elements_.emplace_back(TElement{numId, metaSizeBytes, dataSizeBytes});
    }

    ui32 Size() const {
        return Elements_.size();
    }

    auto GetNumId(size_t idx) const {
        return Elements_[idx].NumId;
    }

    auto GetMetaSizeBytes(size_t idx) const {
        return Elements_[idx].MetaSizeBytes;
    }

    auto GetDataSizeBytes(size_t idx) const {
        return Elements_[idx].DataSizeBytes;
    }

private:
    struct TElement {
        ui32 NumId;
        ui32 MetaSizeBytes;
        ui32 DataSizeBytes;
    };

    TVector<TElement> Elements_;
};

void EncodeIndex(IOutputStream* out, const TSlogIndex& index);
TSlogIndex DecodeIndex(IInputStream* in);

struct TLogMetaRecord {
    NTsModel::EPointType Kind;
    NMonitoring::TLabels Labels;
    size_t PointsCount;
    ui32 DataSize;
};

struct TLogDataRecord {
    ui32 NumId;
    ui32 StepMillis;
    NTsModel::EPointType Kind;
    TAggrTimeSeries TimeSeries;
    ELogFlagsComb Flags;
};

class ILogDataIterator {
public:
    virtual ~ILogDataIterator() = default;
    virtual ui32 NumId() = 0;
    virtual TInstant CommonTs() = 0;
    virtual TDuration Step() = 0;
    virtual NMonitoring::ETimePrecision TimePrecision() = 0;

    virtual bool HasNext() = 0;
    virtual TLogDataRecord Next() = 0;
};

using ILogDataIteratorPtr = THolder<ILogDataIterator>;

ILogDataIteratorPtr CreateLogDataIterator(IInputStream* in);

} // namespace NSolomon::NSlog
