#include "builder.h"
#include "header.h"

#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/ts_codec/bits.h>

#include <library/cpp/monlib/encode/spack/compression.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NMonitoring;

namespace NSolomon::NSlog::NSnapshotData {

class TSnapshotLogDataBuilder: public ISnapshotLogDataBuilder {
public:
    TSnapshotLogDataBuilder(
        ui32 numId,
        ECompression compressionAlg,
        IOutputStream* out)
        : NumId_{numId}
        , CompressionAlg_{compressionAlg}
        , Out_{out}
    {
        CompressedOut_ = CompressedOutput(TempOut_, CompressionAlg_);
        if (CompressedOut_) {
            TempOut_ = CompressedOut_.Get();
        }
    }

    void Close() override {
        if (IsClosed_) {
            return;
        }

        IsClosed_ = true;
        NSnapshotData::WriteHeader(Out_, NSnapshotData::CreateHeader(NumId_, CompressionAlg_, MetricsCount_, PointsCount_));
        TempOut_->Finish();

        // TODO: a place for an optimization. Pass an arg stream that supports position changing
        const auto& tempBuffer = TempData_.Buffer();
        Out_->Write(tempBuffer.Data(), tempBuffer.Size());
    }

    TBytes OnTimeSeries(NTsModel::EPointType type, ui16 columnSetMask, NTs::TBitSpan encoded, size_t numPoints) override {
        Y_ENSURE(encoded.Size() != 0, "cannot log empty time series");

        TBytes written = WriteFixed(TempOut_, PackTypes(type, NMonitoring::EValueType::NONE));
        written += WriteFixed(TempOut_, columnSetMask);
        written += WriteFixed(TempOut_, encoded.Size());
        TempOut_->Write(encoded.Data(), encoded.SizeBytes());
        written += encoded.SizeBytes();

        ++MetricsCount_;
        PointsCount_ += numPoints;
        return written;
    }

private:
    const ui32 NumId_;
    const ECompression CompressionAlg_;
    IOutputStream* Out_;
    TBufferStream TempData_;
    IOutputStream* TempOut_{&TempData_};
    THolder<IOutputStream> CompressedOut_;
    bool IsClosed_{false};

    TInstant CommonTime_;
    TDuration Step_;
    ui32 MetricsCount_{0};
    ui32 PointsCount_{0};
};

ISnapshotLogDataBuilderPtr CreateSnapshotLogDataBuilder(ui32 numId, ECompression compression, IOutputStream* out) {
    return MakeHolder<TSnapshotLogDataBuilder>(numId, compression, out);
}

} // NSolomon::NSlog::NSnapshotData
