#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/ts_codec/bit_span.h>
#include <solomon/libs/cpp/ts_model/point_type.h>

#include <library/cpp/monlib/encode/format.h>

#include <util/generic/fwd.h>

namespace NSolomon::NSlog::NSnapshotData {

class ISnapshotLogDataBuilder {
public:
    virtual ~ISnapshotLogDataBuilder() = default;

    virtual void Close() = 0;

    virtual TBytes OnTimeSeries(
        NTsModel::EPointType type,
        ui16 columnSetMask,
        NTs::TBitSpan encoded,
        size_t numPoints) = 0;
};

using ISnapshotLogDataBuilderPtr = THolder<ISnapshotLogDataBuilder>;

ISnapshotLogDataBuilderPtr CreateSnapshotLogDataBuilder(
    ui32 numId,
    NMonitoring::ECompression compressionAlg,
    IOutputStream* out);

} // NSolomon::NSlog::NSnapshotData
