#include "header.h"

#define INCLUDE_CODEC_IMPL_H
#include <solomon/libs/cpp/slog/codec/codec_impl.h>
#undef INCLUDE_CODEC_IMPL_H

namespace NSolomon::NSlog::NSnapshotData {

THeader CreateHeader(ui32 numId, NMonitoring::ECompression compression, ui32 metrics, ui32 points) {
    return THeader{
        VALID_MAGIC,
        CURRENT_VERSION,
        NMonitoring::EncodeCompression(compression),
        numId,
        metrics,
        points
    };
}

THeader ReadHeader(IInputStream* in) {
    auto result = ReadFixed<THeader>(in);
    if (result.Magic != NSnapshotData::VALID_MAGIC) {
        ythrow TDecodeError()
            << "invalid data magic: expected " << NSnapshotData::VALID_MAGIC << ", "
            << "got " << result.Magic;
    }

    if (result.Version < MIN_VERSION || result.Version > MAX_VERSION) {
        ythrow TDecodeError()
            << "unsupported version: " << result.Version;
    }

    if (!NMonitoring::TryDecodeCompression(result.CompressionAlg, nullptr)) {
        ythrow TDecodeError()
            << "unknown data compression algorithm: " << result.CompressionAlg;
    }

    return result;
}

TBytes WriteHeader(IOutputStream* out, THeader header) {
    return WriteFixed(out, header);
}

} // NSolomon::NSlog::NSnapshotData
