#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>

#include <library/cpp/monlib/encode/format.h>

#include <util/stream/input.h>
#include <util/stream/output.h>

namespace NSolomon::NSlog::NSnapshotData {

enum EVersion : ui8 {
    INIT = 1
};

static constexpr ui8 CURRENT_VERSION = EVersion::INIT;
static constexpr ui8 MIN_VERSION = EVersion::INIT;
static constexpr ui8 MAX_VERSION = EVersion::INIT;
static constexpr ui16 VALID_MAGIC = 0x4453; // "SD" in LE-order

struct Y_PACKED THeader {
    ui16 Magic; // 2
    ui8 Version; // 3
    ui8 CompressionAlg; // 4
    ui32 NumId; // 8
    ui32 MetricsCount; // 12
    ui32 PointsCount; // 16
};

THeader CreateHeader(ui32 numId, NMonitoring::ECompression compression, ui32 metrics = 0, ui32 points = 0);

THeader ReadHeader(IInputStream* in);

TBytes WriteHeader(IOutputStream* out, THeader header);

} // namespace NSolomon::NSlog::NSnapshotData
