#pragma once

#include <solomon/libs/cpp/ts_model/point_type.h>
#include <solomon/libs/cpp/ts_codec/bit_buffer.h>

#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/generic/buffer.h>
#include <util/stream/input.h>

namespace NSolomon::NSlog::NSnapshotData {

struct TSnapshotLogDataRecord {
    NTsModel::EPointType Type;
    ui16 ColumnSetMask;
    NTs::TBitBuffer Encoded;
};

class ISnapshotLogDataIterator {
public:
    virtual ~ISnapshotLogDataIterator() = default;
    virtual ui32 NumId() = 0;
    virtual ui32 TotalMetricCount() = 0;
    virtual ui32 TotalPointCount() = 0;

    virtual bool HasNext() = 0;
    virtual TSnapshotLogDataRecord Next() = 0;
};

using ISnapshotLogDataIteratorPtr = std::unique_ptr<ISnapshotLogDataIterator>;

ISnapshotLogDataIteratorPtr CreateSnapshotLogDataIterator(IInputStream* in);

} // namespace NSolomon::NSlog::NSnapshotData
