#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/ts_model/point_type.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/metric_type.h>
#include <library/cpp/monlib/metrics/labels.h>

namespace NSolomon::NSlog::NUnresolvedMeta {

class IUnresolvedMetaBuilder {
public:
    virtual ~IUnresolvedMetaBuilder() = default;

    virtual void Close() = 0;
    virtual void OnCommonLabels(NMonitoring::TLabels&&) = 0;
    virtual void OnMetric(
        NTsModel::EPointType type,
        NMonitoring::TLabels&& labels,
        size_t pointsCnt,
        TBytes bytes) = 0;
};

using IUnresolvedMetaBuilderPtr = THolder<IUnresolvedMetaBuilder>;

IUnresolvedMetaBuilderPtr CreateUnresolvedMetaBuilder(
    ui32 numId,
    NMonitoring::ECompression compressionAlg,
    IOutputStream* out);

} // namespace NSolomon::NSlog::NUnresolvedMeta
