#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>

#include <library/cpp/monlib/encode/format.h>

#include <util/stream/input.h>
#include <util/stream/output.h>

namespace NSolomon::NSlog::NUnresolvedMeta {

enum EVersion : ui8 {
    INIT = 1
};

static constexpr EVersion CURRENT_VERSION = EVersion::INIT;
static constexpr EVersion MIN_VERSION = EVersion::INIT;
static constexpr EVersion MAX_VERSION = EVersion::INIT;
static constexpr ui16 VALID_MAGIC = 0x4D55; // "UM" in LE-order

struct THeader {
    EVersion Version = CURRENT_VERSION;
    NMonitoring::ECompression CompressionAlg = NMonitoring::ECompression::IDENTITY;
    ui32 NumId = 0;
    TBytes LabelNamesPoolBytesSize = 0;
    TBytes LabelValuesPoolBytesSize = 0;
    ui32 MetricsCount = 0;
    ui32 PointsCount = 0;
};

THeader ReadHeader(IInputStream* in);

TBytes WriteHeader(IOutputStream* out, THeader header);

} // namespace NSolomon::NSlog::NUnresolvedMeta
