#pragma once

#include <solomon/libs/cpp/slog/codec/fwd.h>
#include <solomon/libs/cpp/labels/labels.h>
#include <solomon/libs/cpp/ts_model/point_type.h>

#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/generic/buffer.h>
#include <util/stream/input.h>
#include <util/generic/vector.h>

#include <vector>

namespace NSolomon::NSlog::NUnresolvedMeta {

struct TUnresolvedMetaRecord {
    NTsModel::EPointType Type;
    NLabels::TLabels Labels;
    ui32 PointCounts;
    TBytes DataSize;
};

class IUnresolvedMetaIterator {
public:
    virtual ~IUnresolvedMetaIterator() = default;
    virtual ui32 NumId() = 0;
    virtual ui32 TotalMetricCount() = 0;
    virtual ui32 TotalPointCount() = 0;

    virtual bool HasNext() = 0;
    virtual TUnresolvedMetaRecord Next() = 0;
    virtual size_t SizeBytes() const = 0;
};

using IUnresolvedMetaIteratorPtr = std::unique_ptr<IUnresolvedMetaIterator>;

IUnresolvedMetaIteratorPtr CreateUnresolvedMetaIterator(IInputStream* in);

IUnresolvedMetaIteratorPtr CreateUnresolvedMetaIterator(TString meta);

} // namespace NSolomon::NSlog::NUnresolvedMeta
