#include <solomon/libs/cpp/slog/unresolved_meta/header.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/size_literals.h>
#include <util/stream/buffer.h>
#include <util/generic/buffer.h>

using namespace NSolomon::NSlog::NUnresolvedMeta;


TEST(TSlogUnresolvedMetaHeaderTest, EncodeDecode) {
    THeader header;
    header.NumId = 3078450851;
    header.PointsCount = 214;
    header.MetricsCount = 20;
    header.LabelNamesPoolBytesSize = 1_KB;
    header.LabelValuesPoolBytesSize = 8_MB;
    header.CompressionAlg = NMonitoring::ECompression::ZLIB;

    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto bytes = WriteHeader(&out, header);
        ASSERT_EQ(bytes, buffer.size());
    }
    {
        TBufferInput in(buffer);
        THeader actual = ReadHeader(&in);
        ASSERT_EQ(header.NumId, actual.NumId);
        ASSERT_EQ(header.PointsCount, actual.PointsCount);
        ASSERT_EQ(header.MetricsCount, actual.MetricsCount);
        ASSERT_EQ(header.LabelNamesPoolBytesSize, actual.LabelNamesPoolBytesSize);
        ASSERT_EQ(header.LabelValuesPoolBytesSize, actual.LabelValuesPoolBytesSize);
        ASSERT_EQ(header.Version, actual.Version);
        ASSERT_EQ(header.CompressionAlg, actual.CompressionAlg);
    }
    EXPECT_THROW(ythrow yexception() << "msg", yexception);
}

TEST(TSlogUnresolvedMetaHeaderTest, InvalidHeader) {
    TString buffer = "UMInvalidHeaderThatShouldFail1111";
    TStringInput in(buffer);
    EXPECT_THROW(ReadHeader(&in), NSolomon::NSlog::TDecodeError);
}

TEST(TSlogUnresolvedMetaHeaderTest, CorruptedHeader) {
    THeader header;
    header.NumId = 1684122135;
    header.PointsCount = 15;
    header.MetricsCount = 255;
    header.LabelNamesPoolBytesSize = 2_KB;
    header.LabelValuesPoolBytesSize = 1_MB;
    header.CompressionAlg = NMonitoring::ECompression::IDENTITY;

    TBuffer buffer;
    {
        TBufferOutput out(buffer);
        auto bytes = WriteHeader(&out, header);
        ASSERT_EQ(bytes, buffer.size());
    }

    {
        buffer.Resize(buffer.size() / 2);
        TBufferInput in(buffer);
        EXPECT_THROW(ReadHeader(&in), NSolomon::NSlog::TDecodeError);
    }
}
