#include "java_objects.h"

namespace NSolomon::NJava {

TBuffer ToBuffer(JNIEnv* jenv, jbyteArray array) {
    jbyte* data = jenv->GetByteArrayElements(array, nullptr);
    jsize size = jenv->GetArrayLength(array);
    TBuffer buffer(reinterpret_cast<const char*>(data), static_cast<size_t>(size));
    jenv->ReleaseByteArrayElements(array, data, JNI_ABORT);
    return buffer;
}

jbyteArray ToByteArray(JNIEnv* jenv, const TBuffer& buf) {
    jbyteArray array = jenv->NewByteArray(buf.size());
    jenv->SetByteArrayRegion(array, 0, buf.size(), reinterpret_cast<const jbyte*>(buf.data()));
    return array;
}

} // namespace NSolomon::NJava
