#pragma once

#include <util/generic/buffer.h>

#include <jni.h>

namespace NSolomon::NJava {

TBuffer ToBuffer(JNIEnv* jenv, jbyteArray array);
jbyteArray ToByteArray(JNIEnv* jenv, const TBuffer& buf);

class TByteArray {
public:
    TByteArray(JNIEnv* jenv, jbyteArray array);
    ~TByteArray();

    jbyte* Data() const noexcept {
        return Data_;
    }

    jsize Size() const noexcept {
        return Size_;
    }

private:
    JNIEnv* Jenv_;
    jbyteArray Array_;
    jbyte* Data_;
    jsize Size_;
};

} // namespace NSolomon::NJava
