#pragma once

#include "dc.h"
#include "env.h"

#include <solomon/libs/cpp/error_or/error_or.h>

#include <util/stream/file.h>
#include <util/folder/path.h>
#include <util/generic/serialized_enum.h>

namespace NSolomon {

struct TSolomonEnv {
    EDc Dc{EDc::UNKNOWN};
    EEnvironment Env{EEnvironment::DEVELOPMENT};
    TString Fqdn;
};

TErrorOr<TSolomonEnv, TGenericError> LoadSolomonEnv(const TFsPath& baseDir = "/etc/solomon") noexcept;

} // namespace NSolomon
