#pragma once

#include <util/datetime/base.h>

#include <chrono>

namespace NSolomon {

class TSteadyTimer {
    using TTimePoint = std::chrono::steady_clock::time_point;

public:
    TSteadyTimer() {
        Reset();
    }

    void Reset() {
        Time_ = std::chrono::steady_clock::now();
    }

    TDuration Step() {
        TTimePoint now = std::chrono::steady_clock::now();
        TDuration d = TDuration::MicroSeconds(
            std::chrono::duration_cast<std::chrono::microseconds>(now - Time_).count());

        Time_ = now;

        return d;
    }

private:
    TTimePoint Time_;
};

} // namespace NSolomon
