#include "column_set.h"

#include <util/stream/output.h>

namespace NSolomon::NStockpile {

void TColumnSetCodec::Encode(const NTs::TColumnSet& cs, TCodecOutput* out) {
    ui32 mask = cs.Mask();
    out->WriteFixed(mask);
}

NTs::TColumnSet TColumnSetCodec::Decode(TCodecInput* in) {
    STOCKPILE_CODEC_ENSURE(in->Left() >= sizeof(ui32), "cannot read column set, left " << in->Left() << " bytes");
    ui32 mask = in->ReadFixed<ui32>();
    STOCKPILE_CODEC_ENSURE(mask <= NTs::TColumnSet::MaxMask, "invalid column mask: " << mask);
    return NTs::TColumnSet{static_cast<NTs::TColumnsMask>(mask)};
}

} // namespace NSolomon::NStockpile

