#pragma once

#include <util/system/types.h>
#include <util/generic/yexception.h>

namespace NSolomon::NStockpile {

enum class EFormat: ui8 {
    HISTOGRAM_DENOM_37 = 37,
    IDEMPOTENT_WRITE_38 = 38,
    DELETED_SHARDS_39 = 39,
};

inline constexpr EFormat MinSupportedFormat = EFormat::HISTOGRAM_DENOM_37;
inline constexpr EFormat MaxSupportedFormat = EFormat::DELETED_SHARDS_39;

inline void CheckFormatValid(ui32 format) {
    auto min = static_cast<ui32>(NStockpile::MinSupportedFormat);
    auto max = static_cast<ui32>(NStockpile::MaxSupportedFormat);
    Y_ENSURE(format >= min && format <= max,
        "invalid stockpile format (" << format << ") must be in [" << min << ", " << max << ']');
}

inline EFormat FormatFromInt(ui32 format) {
    CheckFormatValid(format);
    return static_cast<EFormat>(format);
}

} // namespace NSolomon::NStockpile
