#pragma once

#include "codec.h"
#include "column_set.h"
#include "format.h"
#include "metric_header.h"

#include <solomon/libs/cpp/ts_codec/bit_buffer.h>

#include <util/generic/buffer.h>

namespace NSolomon::NStockpile {

class TMetricArchive {
public:
    TMetricArchive(
            TMetricHeader header,
            EFormat format,
            NTs::TColumnSet columns,
            ui32 pointCount,
            NTs::TBitBuffer data) noexcept
        : Header_{header}
        , Format_{format}
        , Columns_{columns}
        , PointCount_{pointCount}
        , Data_{std::move(data)}
    {
    }

    // empty archive
    TMetricArchive(TMetricHeader header, EFormat format) noexcept
        : Header_{header}
        , Format_{format}
        , PointCount_{0}
    {
    }

    explicit TMetricArchive(EFormat format) noexcept
        : Format_{format}
        , PointCount_{0}
    {
    }

    const TMetricHeader& Header() const noexcept {
        return Header_;
    }

    EFormat Format() const noexcept {
        return Format_;
    }

    NTs::TColumnSet Columns() const noexcept {
        return Columns_;
    }

    ui32 PointCount() const noexcept {
        return PointCount_;
    }

    const NTs::TBitSpan Data() const & noexcept{
        return Data_;
    }

    const NTs::TBitBuffer Data() const && noexcept {
        return std::move(Data_);
    }

    bool operator==(const TMetricArchive& rhs) const noexcept = default;

private:
    TMetricHeader Header_;
    EFormat Format_;
    NTs::TColumnSet Columns_;
    ui32 PointCount_;
    NTs::TBitBuffer Data_;  // TODO: replace with bit span
};

class TMetricArchiveCodec: public ICodec<TMetricArchive> {
public:
    explicit TMetricArchiveCodec(EFormat format) noexcept
        : Format_{format}
    {
    }

    void Encode(const TMetricArchive& archive, TCodecOutput* out) override;
    TMetricArchive Decode(TCodecInput* in) override;

private:
    EFormat Format_;
};

} // namespace NSolomon::NStockpile
