#pragma once

#include "codec.h"

#include <solomon/protos/model/metric.pb.h>

#include <util/datetime/base.h>

namespace NSolomon::NStockpile {

struct TMetricOwner {
    ui32 ProjectId{0};
    ui32 ShardId{0};

    bool operator==(const TMetricOwner& rhs) const noexcept = default;
};

struct TMetricHeader {
    TMetricOwner Owner;
    TInstant DeleteBefore;
    ui32 DecimPolicyId{0};
    yandex::solomon::model::MetricType Type{yandex::solomon::model::METRIC_TYPE_UNSPECIFIED};

    bool operator==(const TMetricHeader& rhs) const noexcept = default;
};

class TMetricHeaderCodec: public ICodec<TMetricHeader> {
public:
    void Encode(const TMetricHeader& header, TCodecOutput* out) override;
    TMetricHeader Decode(TCodecInput* in) override;
};

} // namespace NSolomon::NStockpile
