#include <solomon/libs/cpp/stockpile_codec/codec.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NStockpile;

TEST(TCodecTest, VarInt32) {
    std::vector<ui32> numbers{0, 0x7f, 0x80, 0xff, ui32(0x7fffffff), ui32(0x80000000), ui32(0xffffffff)};

    TCodecOutput out{16};
    for (ui32 n: numbers) {
        out.WriteVarInt32(n);
    }

    auto buf = out.TakeBuffer();
    TCodecInput in{buf};
    for (ui32 n: numbers) {
        auto value = in.ReadVarInt32();
        ASSERT_TRUE(value.has_value());
        EXPECT_EQ(n, *value);
    }
}

TEST(TCodecTest, InvalidVarInt32) {
    TCodecInput in{TStringBuf("\xff\xff\xff\xff\xff")};
    auto value = in.ReadVarInt32();
    ASSERT_TRUE(!value.has_value());
}

TEST(TCodecTest, VarInt64) {
    std::vector<ui64> numbers{
        0, 0x7f, 0x80, 0xff,
        ui64(0x7fffffff),
        ui64(0x80000000),
        ui64(0xffffffff),
        ui64(0x7fffffffffffffff),
        ui64(0x8000000000000000),
        ui64(0xffffffffffffffff),
    };

    TCodecOutput out{16};
    for (ui64 n: numbers) {
        out.WriteVarInt64(n);
    }

    auto buf = out.TakeBuffer();
    TCodecInput in{buf};
    for (ui64 n: numbers) {
        auto value = in.ReadVarInt64();
        ASSERT_TRUE(value.has_value());
        EXPECT_EQ(n, *value);
    }
}
