#include <solomon/libs/cpp/stockpile_codec/column_set.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NStockpile;

TEST(TColumnSetTest, EncodeDecode) {
    NTs::TColumnSet columns{NTs::EColumn::TS, NTs::EColumn::LONG_VALUE, NTs::EColumn::STEP};

    TCodecOutput out{16};
    TColumnSetCodec codec;
    codec.Encode(columns, &out);

    TBuffer buf = out.TakeBuffer();
    EXPECT_EQ(buf.size(), 4u);

    TCodecInput in{buf};
    NTs::TColumnSet decodedColumns = codec.Decode(&in);
    EXPECT_EQ(columns, decodedColumns);
}
